<?php

namespace App\Filament\Resources;

use App\Filament\Resources\AccessControlResource\Pages;
use App\Filament\Resources\AccessControlResource\RelationManagers;
use App\Models\AccessControl;
use App\Models\Computer;
use App\Models\Enum\RoleEnum;
use App\Models\Side;
use App\Models\UserType;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class AccessControlResource extends Resource
{
    protected static ?string $model = AccessControl::class;

    protected static ?string $navigationGroup = "Computer Management";

    protected static ?string $navigationIcon = 'heroicon-s-hand-raised';

    public static function canViewAny(): bool
    {
        return auth()->user()->role_id !== RoleEnum::ID[RoleEnum::SIDE_USER];
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label('Name')
                    ->required()
                    ->maxLength(255),

                Forms\Components\TextInput::make('description')
                    ->label('Description')
                    ->nullable()
                    ->maxLength(1000),

                Forms\Components\Select::make('side_id')
                    ->label('Side')
                    ->searchable()
                    ->options(Side::all()->pluck('name', 'id'))
                    ->nullable(),

                Forms\Components\Select::make('user_type_id')
                    ->label('User Type')
                    ->searchable()
                    ->options(UserType::all()->pluck('name', 'id'))
                    ->nullable(),

                Forms\Components\TagsInput::make('white_list')
                    ->label('White List')
                    ->nullable()
                    ->placeholder('Add IPs, Domains'),

                Forms\Components\TagsInput::make('black_list')
                    ->label('Black List')
                    ->nullable()
                    ->placeholder('Add IPs, Domains'),

                Forms\Components\TagsInput::make('allowed_apps')
                    ->label('Allowed Apps')
                    ->nullable()
                    ->placeholder('Add application names'),

                Forms\Components\TagsInput::make('blocked_apps')
                    ->label('Blocked Apps')
                    ->nullable()
                    ->placeholder('Add application names'),

                Forms\Components\DateTimePicker::make('active_from_date')
                    ->label('Active From')
                    ->nullable(),

                Forms\Components\DateTimePicker::make('deactivate_date')
                    ->label('Deactivate Date')
                    ->nullable(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label('Name')
                    ->sortable()
                    ->searchable(),

                Tables\Columns\TextColumn::make('description')
                    ->label('Description'),

                Tables\Columns\TextColumn::make('side.name')
                    ->label('Side'),

                Tables\Columns\TextColumn::make('userType.name')
                    ->label('User Type'),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('user_type_id')
                    ->label('User Type')
                    ->options(UserType::all()->pluck('name', 'id')->toArray())
                    ->searchable()
                    ->placeholder('Select User Type'),

                Tables\Filters\SelectFilter::make('side_id')
                    ->label('Select Side (Library)')
                    ->options(Side::all()->pluck('name', 'id')->toArray())
                    ->searchable()
                    ->placeholder('Select Side (Library)'),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAccessControls::route('/'),
            'create' => Pages\CreateAccessControl::route('/create'),
            'edit' => Pages\EditAccessControl::route('/{record}/edit'),
        ];
    }
}
