<?php

namespace App\Filament\Resources\AccessControlResource\Pages;

use App\Filament\Resources\AccessControlResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateAccessControl extends CreateRecord
{
    protected static string $resource = AccessControlResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data["white_list"] = json_encode($data["white_list"]);
        $data["black_list"] = json_encode($data["black_list"]);
        $data["allowed_apps"] = json_encode($data["allowed_apps"]);
        $data["blocked_apps"] = json_encode($data["blocked_apps"]);

        return $data;
    }
}
