<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SessionStatusResource\Pages;
use App\Filament\Resources\SessionStatusResource\RelationManagers;
use App\Models\Enum\RoleEnum;
use App\Models\SessionStatus;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class SessionStatusResource extends Resource
{
    protected static ?string $model = SessionStatus::class;

    protected static ?string $navigationGroup = "Control Panel";

    protected static ?string $navigationIcon = 'heroicon-o-wrench';

    public static function canViewAny(): bool
    {
        return auth()->user()->role_id !== RoleEnum::ID[RoleEnum::SIDE_USER];
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label('Name')
                    ->required()
                    ->maxLength(255),

                Forms\Components\TextInput::make('description')
                    ->label('Description')
                    ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make("name")
                    ->label('Name')
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make("description")
                    ->label('Description')
                    ->searchable()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                //Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSessionStatuses::route('/'),
            'create' => Pages\CreateSessionStatus::route('/create'),
            //'edit' => Pages\EditSessionStatus::route('/{record}/edit'),
        ];
    }
}
