<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ApiKeyMiddleware {
    private const X_API_KEY = "X-API-KEY";

    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response {
        $apiKey = $request->header(self::X_API_KEY);

        if (!$apiKey) {
            return response()->json(['error' => 'API key required'], 401);
        }

        $validApiKey = env("API_KEY");

        if ($apiKey !== $validApiKey) {
            return response()->json(['error' => 'Invalid API key'], 401);
        }

        return $next($request);
    }
}
