<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AccessControl extends Model
{
    protected $fillable = [
        'name',
        'description',
        'computer_id',
        'side_id',
        'user_type_id',
        'white_list',
        'black_list',
        'allowed_apps',
        'blocked_apps',
        'active_from_date',
        'deactivate_date'
    ];

    public function side(): BelongsTo
    {
        return $this->belongsTo(Side::class);
    }

    public function userType(): BelongsTo
    {
        return $this->belongsTo(UserType::class);
    }
}
