<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Booking extends Model
{
    protected $fillable = [
        "user_id",
        "computer_id",
        "side_id",
        "booking_status_id",
        "date",
        "cancellation_reason",
        "creator_user",
        "start_time",
        "end_time",
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function computer(): BelongsTo
    {
        return $this->belongsTo(Computer::class);
    }

    public function side(): BelongsTo
    {
        return $this->belongsTo(Side::class);
    }

    public function bookingStatus(): BelongsTo
    {
        return $this->belongsTo(BookingStatus::class);
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'creator_user');
    }

    public function userSession(): HasOne
    {
        return $this->hasOne(UserSession::class);
    }
}
