<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Computer extends Model
{
    protected $fillable = [
        "name",
        "mac_address",
        "ip_address",
        "side_id",
        "computer_status_id",
        "computer_type_id",
        "reserved",
        "current_user_id",
        "reserved_until",
        "user_session_id",
        "browser_info",
        "maintenance_required",
        "allowed_pages",
        "blocked_pages",
        "os_version",
    ];

    public function side(): BelongsTo
    {
        return $this->belongsTo(Side::class);
    }

    public function status(): BelongsTo
    {
        return $this->belongsTo(ComputerStatus::class, 'computer_status_id');
    }

    public function type(): BelongsTo
    {
        return $this->belongsTo(ComputerType::class, 'computer_type_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'current_user_id');
    }

    public function userSession(): BelongsTo
    {
        return $this->belongsTo(UserSession::class, 'user_session_id');
    }

    public function accessControl(): HasOne
    {
        return $this->hasOne(AccessControl::class);
    }

    public function bookings()
    {
        return $this->hasMany(Booking::class, 'computer_id');
    }
}
