<?php

namespace App\Models\RequestBodyDto;

class ComputerRegisterRequestBody
{
    private string $name;
    private string $macAddress;
    private string $ipAddress;
    private string $sideCode;
    private string $type;

    public function __construct(
        string $name,
        string $macAddress,
        string $ipAddress,
        string $sideCode,
        string $type
    ) {
        $this->name = $name;
        $this->macAddress = $macAddress;
        $this->ipAddress = $ipAddress;
        $this->sideCode = $sideCode;
        $this->type = $type;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getMacAddress(): string
    {
        return $this->macAddress;
    }

    public function getIpAddress(): string
    {
        return $this->ipAddress;
    }

    public function getSideCode(): string
    {
        return $this->sideCode;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public static function createFromPrimitives(
        string $name,
        string $macAddress,
        string $ipAddress,
        string $sideCode,
        string $type
    ): self
    {
        return new self(
            $name,
            $macAddress,
            $ipAddress,
            $sideCode,
            $type
        );
    }
}
