<?php

namespace App\Models\RequestBodyDto;

class InitTerminalSessionRequestBody
{
    private string $personIdentifier;
    private string $macAddress;
    private string $localTime;
    private string $pin;

    public function __construct(
        string $personIdentifier,
        string $macAddress,
        string $localTime,
        string $pin
    ) {
        $this->personIdentifier = $personIdentifier;
        $this->macAddress = $macAddress;
        $this->localTime = $localTime;
        $this->pin = $pin;
    }

    public function getPersonIdentifier(): string
    {
        return $this->personIdentifier;
    }

    public function getMacAddress(): string
    {
        return $this->macAddress;
    }

    public function getLocalTime(): string
    {
        return $this->localTime;
    }

    public function getPIN(): string
    {
        return $this->pin;
    }

    public static function createFromPrimitives(
        string $personIdentifier,
        string $macAddress,
        string $localTime,
        string $pin
    ): self
    {
        return new self(
            $personIdentifier,
            $macAddress,
            $localTime,
            $pin
        );
    }
}
