<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Side extends Model
{
    protected $casts = [
        'operating_hours_winter' => 'array',
        'operating_hours_summer' => 'array',
    ];

    protected $fillable = [
        "identifier",
        "name",
        "description",
        "address",
        "postal_code",
        "location",
        "lat_long",
        "contact_email",
        "contact_phone",
        "image_url",
        "winter_start_date",
        "summer_start_date",
        "operating_hours_winter",
        "operating_hours_summer",
    ];

    public function computers(): HasMany
    {
        return $this->hasMany(Computer::class);
    }

    public function bookings(): HasMany
    {
        return $this->hasMany(Booking::class);
    }
}
