<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserSession extends Model
{
    protected $fillable = [
        'side_id',
        'computer_id',
        'session_status_id',
        'booking_id',
        'start_time',
        'end_time',
        'user_authenticated',
        'authentication_timestamp',
        'session_ip',
        'print_requests_count',
        'print_credits_used',
        'session_time_limit_exceeded',
        'is_active',
        'duration',
    ];

    public function side(): BelongsTo
    {
        return $this->belongsTo(Side::class);
    }

    public function computer(): BelongsTo
    {
        return $this->belongsTo(Computer::class);
    }

    public function sessionStatus(): BelongsTo
    {
        return $this->belongsTo(SessionStatus::class);
    }

    public function booking(): BelongsTo
    {
        return $this->belongsTo(Booking::class);
    }
}
