<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserTypeRule extends Model
{
    protected $fillable = [
        'user_type_id',
        'name',
        'description',
        'parameter',
        'parameter_value',
        'active_from_date',
        'deactivate_date',
        'priority'
    ];

    public function userType(): BelongsTo
    {
        return $this->belongsTo(UserType::class);
    }
}
