<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sides', function (Blueprint $table) {
            $table->id();
            $table->string("identifier");
            $table->string("name");
            $table->string("description")->nullable();
            $table->string("address");
            $table->string("postal_code")->nullable();
            $table->string("location")->nullable();
            $table->string("lat_long")->nullable();
            $table->string("contact_email")->nullable();
            $table->string("contact_phone")->nullable();
            $table->string("image_url")->nullable();
            $table->dateTime("winter_start_date");
            $table->dateTime("summer_start_date");
            $table->text("operating_hours_winter");
            $table->text("operating_hours_summer");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sides');
    }
};
