<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create("computers", function (Blueprint $table) {
            $table->id();
            $table->string("name");
            $table->string("mac_address")->nullable();
            $table->string("ip_address")->nullable();
            $table->foreignId("side_id")->constrained("sides");
            $table->foreignId("computer_status_id")->constrained("computer_statuses");
            $table->foreignId("computer_type_id")->constrained("computer_types");
            $table->boolean("reserved");
            $table->integer("current_user_id")->nullable();
            $table->dateTime("reserved_until")->nullable();
            $table->integer("user_session_id")->nullable();
            $table->string("browser_info")->nullable();
            $table->string("system_info")->nullable();
            $table->boolean("maintenance_required");
            $table->text("allowed_pages")->nullable();
            $table->text("blocked_pages")->nullable();
            $table->text("os_version")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('computers');
    }
};
