<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create("bookings", function (Blueprint $table) {
            $table->id();
            $table->foreignId("user_id")->constrained("users");
            $table->foreignId("computer_id")->constrained("computers");
            $table->foreignId("side_id")->constrained("sides");
            $table->foreignId("booking_status_id")->constrained("booking_statuses");
            $table->dateTime("date");
            $table->string("cancellation_reason")->nullable();
            $table->integer("creator_user")->nullable();
            $table->time("start_time");
            $table->time("end_time");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
