<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_type_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId("user_type_id")->constrained("user_types");
            $table->string("name");
            $table->string("description")->nullable();
            $table->string("parameter")->nullable();
            $table->string("parameter_value")->nullable();
            $table->dateTime("active_from_date")->nullable();
            $table->dateTime("deactivate_date")->nullable();
            $table->integer("priority")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_type_rules');
    }
};
