<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('computer_audits', function (Blueprint $table) {
            $table->id();
            $table->integer("user_id")->nullable();
            $table->integer("booking_id")->nullable();
            $table->integer("user_session_id")->nullable();
            $table->integer("computer_id")->nullable();
            $table->integer("side_id")->nullable();
            $table->string("side_name")->nullable();
            $table->string("action")->nullable();
            $table->integer("status")->nullable();
            $table->string("response")->nullable();
            $table->dateTime("event_date")->nullable();
            $table->string("last_error")->nullable();
            $table->text("computer_parameters")->nullable();
            $table->string("computer_type")->nullable();
            $table->string("user_session_time")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('computer_audits');
    }
};
