<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('access_controls', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->integer("side_id")->nullable();
            $table->integer("user_type_id")->nullable();
            $table->text("white_list")->nullable();
            $table->text("black_list")->nullable();
            $table->text("allowed_apps")->nullable();
            $table->text("blocked_apps")->nullable();
            $table->dateTime("active_from_date")->nullable();
            $table->dateTime("deactivate_date")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('access_controls');
    }
};
