<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_sessions', function (Blueprint $table) {
            $table->id();
            $table->foreignId("side_id")->constrained("sides");
            $table->foreignId("computer_id")->constrained("computers");
            $table->foreignId("session_status_id")->constrained("session_statuses");
            $table->foreignId("booking_id")->constrained("bookings")->cascadeOnDelete();
            $table->time("start_time");
            $table->time("end_time");
            $table->integer("duration");
            $table->boolean("user_authenticated")->default(false)->nullable();
            $table->dateTime("authentication_timestamp")->nullable();
            $table->string("session_ip")->nullable();
            $table->integer("print_requests_count")->nullable();
            $table->integer("print_credits_used")->nullable();
            $table->boolean("session_time_limit_exceeded")->nullable();
            $table->boolean("is_active")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_sessions');
    }
};
