<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table("users", function (Blueprint $table) {
            $table->string("library_identifier")->nullable();
            $table->string("pin")->nullable();
            $table->string("sierra_record_number")->nullable();
            $table->string("sex")->nullable();
            $table->string("sierra_type")->nullable();
            $table->string("record_number")->nullable();
            $table->date("birth")->nullable();
            $table->string("location")->nullable();
            $table->string("town")->nullable();
            $table->string("country_born")->nullable();
            $table->string("principal_library")->nullable();
            $table->dateTime("lock_date_until")->nullable();
            $table->string("notice_number")->nullable();
            $table->string("address")->nullable();
            $table->string("identifier")->nullable();
            $table->string("warnings")->nullable();
            $table->boolean("locked")->nullable();
            $table->foreignId("role_id")->constrained("roles")->cascadeOnDelete();
            $table->foreignId("user_type_id")->constrained("roles")->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
