<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('roles')->insert([
            'name' => "Administrador Principal",
            'description' => "Rol con control total de la plataforma, acceso a todo el sistema.",
            "permissions" => '{"can_manage_users": true, "can_manage_computers": true, "can_generate_reports": true, "can_configure_system": true, "can_manage_all_bookings": true, "can_manage_all_roles": true}'
        ]);

        DB::table('roles')->insert([
            'name' => "Administrador",
            'description' => "Rol de administrador del sistema con acceso completo.",
            "permissions" => '"{"can_manage_users": true, "can_manage_computers": true, "can_generate_reports": true}"'
        ]);

        DB::table('roles')->insert([
            'name' => "Supervisor",
            'description' => "Rol con privilegios para supervisar y gestionar usuarios y equipos.",
            'permissions' => '{"can_manage_users": true, "can_view_reports": true, "can_manage_bookings": true}',
        ]);

        DB::table('roles')->insert([
            'name' => "Gestor Biblioteca",
            'description' => "Rol destinado a gestionar las operaciones de la biblioteca.",
            'permissions' => '{"can_manage_computers": true, "can_manage_bookings": true, "can_view_reports": true}',
        ]);

        DB::table('roles')->insert([
            'name' => "Usuario General",
            'description' => "Rol con acceso limitado, solo puede usar el terminal según reserva.",
            'permissions' => '{"can_book_computers": true, "can_use_internet": true, "can_print": true}',
        ]);
    }
}
