<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SessionStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('session_statuses')->insert([
            'name' => "Activa",
            'description' => "La sesión está actualmente activa.",
        ]);

        DB::table('session_statuses')->insert([
            'name' => "Completada",
            'description' => "La sesión ha finalizado correctamente.",
        ]);

        DB::table('session_statuses')->insert([
            'name' => "Cancelada",
            'description' => "La sesión ha sido cancelada.",
        ]);

        DB::table('session_statuses')->insert([
            'name' => "Expirada",
            'description' => "La sesión ha caducado debido al límite de tiempo.",
        ]);

        DB::table('session_statuses')->insert([
            'name' => "Abortada",
            'description' => "La sesión fue interrumpida o falló antes de completar.",
        ]);

        DB::table('session_statuses')->insert([
            'name' => "Pendiente",
            'description' => "La sesión está en espera (por ejemplo, esperando una autenticación).",
        ]);

        DB::table('session_statuses')->insert([
            'name' => "Terminada",
            'description' => "La sesión fue terminada manualmente o por el sistema.",
        ]);
    }
}
