@php
    $side = $getRecord();

    $latLong = $side->lat_long;
    $name = $side->name;
@endphp

@if (!empty($latLong))
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />

    @php $coordinates = explode(',', $latLong); @endphp

    <div id="map-{{ $name }}" style="width: 100%; height: 300px;"></div>

    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const coords = [{{ $coordinates[0] }}, {{ $coordinates[1] }}];
            const map = L.map('map-{{ $name }}').setView(coords, 15);

            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19, }).addTo(map);

            L.marker(coords).addTo(map).bindPopup('{{ $name }}').openPopup();
        });
    </script>
@endif
